import java.util.Scanner;

public class Main {

    static void bubbleSortBy(int[] idx, long[] arr, int n) {
        for (int i = 0; i < n; i++) {
            for (int j = 0; j < n - 1; j++) {
                if (arr[idx[j]] > arr[idx[j + 1]]) {
                    int t = idx[j];
                    idx[j] = idx[j + 1];
                    idx[j + 1] = t;
                }
            }
        }
    }

    static long countGroups(int[] idx, long[] arr, int n) {
        long ans = 0;
        long cnt = 1;
        for (int i = 1; i < n; i++) {
            if (arr[idx[i]] == arr[idx[i - 1]]) {
                cnt++;
            } else {
                ans += cnt * (cnt - 1);
                cnt = 1;
            }
        }
        ans += cnt * (cnt - 1);
        return ans;
    }

    public static void main(String[] args) {
        Scanner in = new Scanner(System.in);

        int n = in.nextInt();
        long[] x = new long[n];
        long[] y = new long[n];
        long[] d1 = new long[n];
        long[] d2 = new long[n];

        for (int i = 0; i < n; i++) {
            x[i] = in.nextLong();
            y[i] = in.nextLong();
            d1[i] = x[i] - y[i];
            d2[i] = x[i] + y[i];
        }

        int[] idx = new int[n];
        for (int i = 0; i < n; i++) idx[i] = i;

        long ans = 0;

        // iste horizontale
        bubbleSortBy(idx, y, n);
        ans += countGroups(idx, y, n);

        // iste vertikale
        for (int i = 0; i < n; i++) idx[i] = i;
        bubbleSortBy(idx, x, n);
        ans += countGroups(idx, x, n);

        // iste NW–SE dijagonale (x - y)
        for (int i = 0; i < n; i++) idx[i] = i;
        bubbleSortBy(idx, d1, n);
        ans += countGroups(idx, d1, n);

        // iste NE–SW dijagonale (x + y)
        for (int i = 0; i < n; i++) idx[i] = i;
        bubbleSortBy(idx, d2, n);
        ans += countGroups(idx, d2, n);

        System.out.println(ans);
    }
}